/*
 *   tangent-circle - Calculate tangent through (0;0) and a given circle
 *   Copyright (C) 2000 Ulf Jordan
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <math.h>

#define DEBUG

int
main(int argc, char **argv)
{
  double x0, y0, R;
  double km, kr, k1, k2, x1, x2, y1, y2;

  printf ("Parameters of the circle:\n");
  printf ("Centre point x0: "); scanf("%le", &x0);
  printf ("             y0: "); scanf("%le", &y0);
  printf ("Radius        R: "); scanf("%le", &R);

  /* Do the calculations */
  if (fabs (R) == fabs (x0))
    {
#ifdef DEBUG
      printf ("R: %f x0: %f\n", fabs (R), fabs (x0));
#endif
      printf ("Vertical tangent with tangent point (0 %f)\n", y0);
      if (y0 != 0)
	{
	  k1 = -(R*R - y0*y0)/(2*x0*y0);
	  x1 = (x0 + k1*y0)/(1 + k1*k1);
	  y1 = k1*x1;
	  printf ("Slope: %f intersection point (%f %f)\n", k1, x1, y1);
	}
    }
  else
    {
      km = -x0*y0/(R*R - x0*x0);
      kr = km*km - (R*R - y0*y0)/(R*R - x0*x0);
      if (kr >= 0)
	{
	  k1 = km + sqrt (kr);
	  k2 = km - sqrt (kr);
	  x1 = (x0 + k1*y0)/(1 + k1*k1);
	  x2 = (x0 + k2*y0)/(1 + k2*k2);
	  y1 = k1*x1;
	  y2 = k2*x2;
	  printf ("Slope: %f intersection point (%f %f)\n", k1, x1, y1);
	  printf ("Slope: %f intersection point (%f %f)\n", k2, x2, y2);
	} else {
	  printf ("There are no tangents passing through (0 0)\n");
      }
    }
}


