/*
 *   diagonal - Calculate parameters of diagonal stems
 *   Copyright (C) 2000 Ulf Jordan
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * The diagonal parameters are defined as given in the figure.
 * b1, b2, S1, and S2 are input parameters. h, k, dx, and dy are the calculated
 * output parameters. S2 is measured perpendicular to the diagonal stem.
 *
 *                         _______________
 *                        /    /|       ^
 *                       /      |       
 *                      /    /  |       
 *                     /        |       
 *                    /    /____|___    
 *                   /    /|    |  ^    
 *                  /    / |    |      
 *          S2     /    /  |    |       b2
 *          ----\ /    /   |    |      
 *               X    /    |    |   dy 
 *              / \  /     |    |      
 *             /   \/      |    |      
 *            /    /\      |    |      
 *           /    /        |    |      
 *          /____/_________|____|__v____v_
 *          |    |         |    |
 *          | h  |    dx   | S1 |      
 *          |<-->|<--------|<-->|             
 *          |        b1         |
 *          |<----------------->|
 */

#include <math.h>

int 
main(int argc, char **argv)
{
  double b1, b2, S1, S2;
  double km, kr, k1, k2, h, dx, dy;

  printf ("Parameters:\n");
  printf ("Width           b1: "); scanf("%le", &b1);
  printf ("Height          b2: "); scanf("%le", &b2);
  printf ("Main stem width S1: "); scanf("%le", &S1);
  printf ("Diagonal sw     S2: "); scanf("%le", &S2);

  /* Do the calculations */
  km = b1*b2/(b1*b1 - S2*S2);
  kr = km*km - (b2*b2 - S2*S2)/(b1*b1 - S2*S2);
  if (kr < 0) 
    {
      printf ("There is no solution\n");
    }
  else
    {
      k1 = km - sqrt (kr);
      k2 = km + sqrt (kr);
      if (b1*k1 - b2 > 0)
	{
	  h = b1 - b2/k1;
          dx = b2/k1 - S1;
          dy = b2 - k1*S1;
          printf("I. k: %f h: %f (dx,dy): %f %f\n",k1,h,dx,dy);
	}
      if (b1*k2 - b2 > 0)
	{
	  h = b1 - b2/k2;
          dx = b2/k2 - S1;
          dy = b2 - k2*S1;
          printf("II. k: %f h: %f (dx,dy): %f %f\n",k2,h,dx,dy);
	}
    }
}


