/*
 *   circle-circle - Calculate intersections between two given circles
 *   Copyright (C) 2000 Ulf Jordan
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <math.h>

double 
e2 (double R1,double x1,double y1,double x,double y)
{
  return((x-x1)*(x-x1)+(y-y1)*(y-y1)-R1*R1);
}

int 
main (int argc, char **argv)
{
  double R0, x1, y1, R1;
  double C, xm, xr, xs1, xs2, y11, y12, y21, y22, x;
  double tol = 0.01;

  printf ("Parameters of first circle:\n");
  printf ("Radius       R0: "); scanf("%le", &R0);
  printf ("Parameters of second circle:\n");
  printf ("Centre point x1: "); scanf("%le", &x1);
  printf ("             y1: "); scanf("%le", &y1);
  printf ("Radius       R1: "); scanf("%le", &R1);

  /* Do the calculations */
  C = R1*R1 - R0*R0 - x1*x1 - y1*y1;
  xm = -C*x1/(2*(x1*x1 + y1*y1));
  xr = xm*xm - (C*C/4 - R0*R0*y1*y1)/(x1*x1 + y1*y1);
  if (xr > 0)
    {
      xs1 = xm + sqrt (xr);
      y11 = sqrt (R0*R0 - xs1*xs1);
      y12 = -y11;
      xs2 = xm - sqrt(xr);
      y21 = sqrt (R0*R0 - xs2*xs2);
      y22 = -y21;
      if (abs (e2 (R1, x1, y1, xs1, y11)) < tol) printf ("(%f %f)\n", xs1, y11);
      if (abs (e2 (R1, x1, y1, xs1, y12)) < tol) printf ("(%f %f)\n", xs1, y12);
      if (abs (e2 (R1, x1, y1, xs2, y21)) < tol) printf ("(%f %f)\n", xs2, y21);
      if (abs (e2 (R1, x1, y1, xs2, y22)) < tol) printf ("(%f %f)\n", xs2, y22);
    } 
  else if (xr == 0)
    {
      x = xm;
      y11 = sqrt(R0*R0 - x*x);
      y12 = -y1;
      if (abs (e2 (R1, x1, y1, x, y11)) < tol) printf ("(%f %f)\n", x, y11);
      if (abs (e2 (R1, x1, y1, x, y12)) < tol) printf ("(%f %f)\n", x, y12);
    } 
  else 
    {
      printf("No intersections\n");
    }
}
